<?php

class EWRporta_DataWriter_Settings extends XenForo_DataWriter
{
	protected $_existingDataErrorPhrase = 'requested_page_not_found';

	protected function _getFields()
	{
		return array(
			'EWRporta_settings' => array(
				'module_name'		=> array('type' => self::TYPE_STRING, 'required' => true),
				'setting_name'		=> array('type' => self::TYPE_STRING, 'required' => true),
				'setting_value'		=> array('type' => self::TYPE_STRING, 'required' => false),
				'setting_desc'		=> array('type' => self::TYPE_STRING, 'required' => false),
				'setting_format'	=> array('type' => self::TYPE_STRING, 'required' => false),
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$setName = $this->_getExistingPrimaryKey($data, 'setting_name'))
		{
			return false;
		}

		return array('EWRporta_settings' => $this->getModelFromCache('EWRporta_Model_Settings')->getSettingByName($setName));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'setting_name = ' . $this->_db->quote($this->getExisting('setting_name'));
	}
}